---
title: Equazione di Pell in Interi e Polinomi
description: "Introduzione alla mia tesi sull'equazione di Pell, spiegando le differenze tra l'equazione polinomiale e quella sugli interi"
keywords: Equazione di Pell, Equazione di Pell polinomiale, Tesi su Equazione di Pell
uuid: 323ef78a-88b2-4ea2-b17e-b0ebb2bcbbb0
publish: true
date: 2022-07-20
lang: it
tags:
  - #kind/work
  - #language/italian
  - #topic/mathematics
  - #topic/pell-equation
---

Dopo qualche anno sono incappato nel materiale che avevo prodotto per la mia tesi triennale, e ho deciso di renderlo disponibile online. L'argomento della tesi è [l'equazione di Pell](https://it.wikipedia.org/wiki/Equazione_di_Pell) [(Archived)](https://web.archive.org/web/20220605/https://it.wikipedia.org/wiki/Equazione_di_Pell) e i metodi di soluzione basati sulle [frazioni continue](https://it.wikipedia.org/wiki/Frazione_continua) [(Archived)](https://web.archive.org/web/20220605/https://it.wikipedia.org/wiki/Frazione_continua), sia nel caso classico sugli interi che nel più recente caso polinomiale.

<!-- More -->

L'equazione di Pell sugli interi chiede, per un fissato $D \in \bbZ$, di trovare e caratterizzare le soluzioni intere $x, y \in \bbZ$ dell'equazione $x^2 - D y^2 = 1$.

Molti teoremi sono noti sull'equazione di Pell, che è stata studiata per più di trecento anni; ad esempio è noto che le soluzioni formano un gruppo abeliano di rango uno, e che l'equazione ammette soluzioni non banali[^soluzioni-banali] per ogni $D$ che non è un quadrato perfetto.

[^soluzioni-banali]: Ovvero diverse da $(\pm 1, 0)$ che sono ovviamente sempre soluzioni.

L'equazione polinomiale è invece meno studiata: essa chiede per un fissato polinomio $D(t) \in \bbZ[t]$ di trovare delle soluzioni polinomiali $P(t), Q(t) \in \bbZ[t]$ che soddisfino $P(t)^2 - D(t) Q(t)^2 = 1$.

La differenza principale dal caso intero è che essa non è risolvibile per tutti i $D(t)$, e in fatti un teorema di Abel mostra una connessione tra la solvibilità dell'equazione con la periodicità dello sviluppo in frazioni continue di $\sqrt{D(t)}$.

La tesi inoltre esplora la questione della minimalità delle specializzazioni delle soluzioni polinomiali, ovvero la connesione tra la minimalità di una soluzione polinomiale $P(t), Q(t) \in \bbZ[t$] e la minimalità della soluzione ottenuta valutando $P$ e $Q$ in $t_0 \in \bbZ$ nell'equazione intera corrispondente a $D = D(t_0)$.

In quell'anno ho parlato dell'equazione di Pell all'esame di passaggio d'anno in [Normale](https://it.wikipedia.org/wiki/Scuola_Normale_Superiore) [(Archived)](https://web.archive.org/web/20220605/https://it.wikipedia.org/wiki/Scuola_Normale_Superiore). Potete trovare [[Colloquio Terzo Anno.pdf|qui]] il pdf di quello che ho detto.
Penso che sia una buona prima lettura introduttiva all'equazione visto che si limita ad enunciare i teoremi principali e a dare molti esempi ed euristiche.

Rendo disponibile anche il [[Tesi Triennale.pdf|pdf della tesi]] e una versione migliorata delle [[Slides Laurea Triennale.pdf|slides]] della presentazione della tesi, anche se la prima non è la miglior referenza per le dimostrazioni, e la seconda è solo una versione più colorata del colloquio di passaggio d'anno.
